/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class EnderportingModifier
extends NoLevelsModifier
implements PlantHarvestModifierHook,
ProjectileHitModifierHook,
ProjectileLaunchModifierHook {
    private static final class_2960 PRIMARY_ARROW = TConstruct.getResource("enderporting_primary");
    private static final Set<class_2709> PACKET_FLAGS = ImmutableSet.of((Object)class_2709.field_12400, (Object)class_2709.field_12398, (Object)class_2709.field_12403);

    @Override
    public int getPriority() {
        return 45;
    }

    private static boolean tryTeleport(class_1309 living, double x, double y, double z) {
        class_1937 world = living.method_5770();
        if (world.field_9236) {
            return false;
        }
        float scaledWidth = living.method_17681() * 0.8f;
        float eyeHeight = living.method_5751();
        class_238 aabb = class_238.method_30048((class_243)new class_243(x, y + (double)(eyeHeight / 2.0f), z), (double)scaledWidth, (double)eyeHeight, (double)scaledWidth);
        boolean didCollide = world.method_20812((class_1297)living, aabb).iterator().hasNext();
        if (didCollide && living.method_17682() > 1.0f) {
            aabb = aabb.method_989(0.0, -1.0, 0.0);
            didCollide = world.method_20812((class_1297)living, aabb).iterator().hasNext();
            y -= 1.0;
        }
        if (!didCollide) {
            EnderportingTeleportEvent event = new EnderportingTeleportEvent(living, x, y, z);
            event.sendEvent();
            if (!event.isCanceled()) {
                if (living instanceof class_3222) {
                    class_3222 playerMP = (class_3222)living;
                    playerMP.field_13987.method_14360(x, y, z, playerMP.method_36454(), playerMP.method_36455(), PACKET_FLAGS);
                } else {
                    living.method_5814(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    for (int i = 0; i < 32; ++i) {
                        serverWorld.method_14199((class_2394)class_2398.field_11214, living.method_23317(), living.method_23318() + world.field_9229.method_43058() * 2.0, living.method_23321(), 1, world.field_9229.method_43059(), 0.0, world.field_9229.method_43059(), 0.0);
                    }
                }
                world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), Sounds.ENDERPORTING.getSound(), living.method_5634(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        class_1309 target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null) {
            class_1309 attacker = context.getAttacker();
            class_243 oldPosition = attacker.method_19538();
            if (EnderportingModifier.tryTeleport(attacker, target.method_23317(), target.method_23318(), target.method_23321())) {
                EnderportingModifier.tryTeleport(target, oldPosition.field_1352, oldPosition.field_1351, oldPosition.field_1350);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void finishBreakingBlocks(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest()) {
            class_2338 pos = context.getPos();
            class_1309 living = context.getLiving();
            if (EnderportingModifier.tryTeleport(living, (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living);
            }
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, class_1838 context, class_3218 world, class_2680 state, class_2338 pos) {
        class_1657 living;
        if (context.method_8037().equals((Object)pos) && (living = context.method_8036()) != null && EnderportingModifier.tryTeleport((class_1309)living, (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f)) {
            ToolDamageUtil.damageAnimated(tool, 2, (class_1309)living, context.method_20287());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, class_1676 projectile, class_3966 hit, @Nullable class_1309 attacker, @Nullable class_1309 target) {
        if (attacker != null && attacker != target && persistentData.getBoolean(PRIMARY_ARROW)) {
            class_1297 hitEntity = hit.method_17782();
            class_243 oldPosition = attacker.method_19538();
            if (attacker.method_37908() == projectile.method_37908() && EnderportingModifier.tryTeleport(attacker, hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321()) && target != null) {
                EnderportingModifier.tryTeleport(target, oldPosition.field_1352, oldPosition.field_1351, oldPosition.field_1350);
            }
        }
        return false;
    }

    @Override
    public boolean onProjectileHitBlock(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, class_1676 projectile, class_3965 hit, @Nullable class_1309 attacker) {
        if (attacker != null && persistentData.getBoolean(PRIMARY_ARROW)) {
            class_2338 target = hit.method_17777().method_10093(hit.method_17780());
            if (attacker.method_37908() == projectile.method_37908() && EnderportingModifier.tryTeleport(attacker, (float)target.method_10263() + 0.5f, target.method_10264(), (float)target.method_10260() + 0.5f)) {
                projectile.method_31472();
            }
        }
        return false;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, class_1309 shooter, class_1676 projectile, @Nullable class_1665 arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary) {
            ToolDamageUtil.damageAnimated(tool, 10, shooter, shooter.method_6058());
            persistentData.putBoolean(PRIMARY_ARROW, true);
        }
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.PLANT_HARVEST, TinkerHooks.PROJECTILE_HIT, TinkerHooks.PROJECTILE_LAUNCH);
    }
}

